<?php
require_once __DIR__ . '/../config.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $loginId = $_GET['login_id'] ?? $_SESSION['pending_login_id'] ?? null;
    
    if (!$loginId) {
        echo json_encode([
            'success' => false,
            'status' => 'not_found',
            'error' => 'Login ID not found'
        ]);
        exit;
    }
    
    $login = getPendingLogin($loginId);
    
    if (!$login) {
        echo json_encode([
            'success' => false,
            'status' => 'not_found',
            'error' => 'Login session not found'
        ]);
        exit;
    }
    
    $status = $login['status'] ?? 'pending';
    $redirectUrl = $login['redirect_url'] ?? REDIRECT_URL;
    
    echo json_encode([
        'success' => true,
        'status' => $status,
        'redirect_url' => $redirectUrl,
        'login_id' => $loginId
    ]);
    exit;
}

echo json_encode(['success' => false, 'error' => 'Invalid request method']);
exit;
